/*:
 
 # Optionals

 Swift is a language designed to help programmers write safer code – to avoid common errors that lead to security holes or applications that crash.
 
 A very common error made by programmers is a failure to anticipate the absence of a value in their program.
 
 "*Optionals* are a special feature in Swift used to indicate that an instance of a variable may not have a value.
 
 If an instance of a variable has no value associated with it, we say that it is *nil*."
 
 By now you are familiar with Swift's basic data types:
 
 * String
 * Int
 * Float
 * Double
 
 "You can use *optionals* with any data type to signal that an instance is potentially **nil**."
 
 (Quotes from **Swift Programming**, Mathias & Gallagher, 2015)
 
 You may wish to make a summary note of these basic ideas in your portfolio entry for today.
 
 When you are ready, follow the link to the next page in this playground.
 
 */
//: [I've made notes and I'm ready to begin!](@next)



